% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export.R
\name{as_latex}
\alias{as_latex}
\title{Output a gt object as LaTeX}
\usage{
as_latex(data)
}
\arguments{
\item{data}{A table object that is created using the \code{\link[=gt]{gt()}} function.}
}
\description{
Get the LaTeX content from a \code{gt_tbl} object as a \code{knit_asis} object. This
object contains the LaTeX code and attributes that serve as LaTeX
dependencies (i.e., the LaTeX packages required for the table). Using
\code{as.character()} on the created object will result in a single-element vector
containing the LaTeX code.
}
\section{Examples}{


Use \code{\link{gtcars}} to create a \strong{gt} table. Add a header and then export as an
object with LaTeX code.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{tab_latex <-
  gtcars \%>\%
  dplyr::select(mfr, model, msrp) \%>\%
  dplyr::slice(1:5) \%>\%
  gt() \%>\%
  tab_header(
    title = md("Data listing from **gtcars**"),
    subtitle = md("`gtcars` is an R dataset")
  ) \%>\%
  as_latex()
}\if{html}{\out{</div>}}

What's returned is a \code{knit_asis} object, which makes it easy to include in R
Markdown documents that are knit to PDF. We can use \code{as.character()} to get
just the LaTeX code as a single-element vector.
}

\section{Function ID}{

13-3
}

\seealso{
Other Export Functions: 
\code{\link{as_raw_html}()},
\code{\link{as_rtf}()},
\code{\link{extract_summary}()},
\code{\link{gtsave}()}
}
\concept{Export Functions}
