% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opts.R
\name{opt_vertical_padding}
\alias{opt_vertical_padding}
\title{Option to expand or contract vertical padding}
\usage{
opt_vertical_padding(data, scale = 1)
}
\arguments{
\item{data}{A table object that is created using the \code{\link[=gt]{gt()}} function.}

\item{scale}{A scale factor by which the vertical padding will be adjusted.
Must be a number between \code{0} and \code{3}.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
Increase or decrease the vertical padding throughout all locations of a
\strong{gt} table by use of a \code{scale} factor, which here is defined by a real
number between \code{0} and \code{3}. This function serves as a shortcut for setting
the following eight options in \code{\link[=tab_options]{tab_options()}}:
\itemize{
\item \code{heading.padding}
\item \code{column_labels.padding}
\item \code{data_row.padding}
\item \code{row_group.padding}
\item \code{summary_row.padding}
\item \code{grand_summary_row.padding}
\item \code{footnotes.padding}
\item \code{source_notes.padding}
}
}
\section{Examples}{


Use \code{\link{exibble}} to create a \strong{gt} table with a number of table parts added.
Contract the vertical padding across the entire table with
\code{opt_vertical_padding()}.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{exibble \%>\%
  gt(rowname_col = "row", groupname_col = "group") \%>\%
  summary_rows(
    groups = "grp_a",
    columns = c(num, currency),
    fns = list(
      min = ~min(., na.rm = TRUE),
      max = ~max(., na.rm = TRUE)
    )) \%>\%
  grand_summary_rows(
    columns = currency,
    fns = list(
      total = ~sum(., na.rm = TRUE)
    )) \%>\%
  tab_source_note(source_note = "This is a source note.") \%>\%
  tab_footnote(
    footnote = "This is a footnote.",
    locations = cells_body(columns = 1, rows = 1)
  ) \%>\%
  tab_header(
    title = "The title of the table",
    subtitle = "The table's subtitle"
  ) \%>\%
  opt_vertical_padding(scale = 0.25)
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_opt_vertical_padding_1.png" style="width:100\%;">
}}
}

\section{Function ID}{

9-4
}

\seealso{
Other Table Option Functions: 
\code{\link{opt_align_table_header}()},
\code{\link{opt_all_caps}()},
\code{\link{opt_css}()},
\code{\link{opt_footnote_marks}()},
\code{\link{opt_horizontal_padding}()},
\code{\link{opt_row_striping}()},
\code{\link{opt_table_font}()},
\code{\link{opt_table_lines}()},
\code{\link{opt_table_outline}()}
}
\concept{Table Option Functions}
