% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_dot_bar.R
\name{gt_plt_dot}
\alias{gt_plt_dot}
\title{Add a color dot and thin bar chart to a table}
\usage{
gt_plt_dot(
  gt_object,
  column,
  category_column,
  palette = NULL,
  max_value = NULL
)
}
\arguments{
\item{gt_object}{An existing gt table object of class \code{gt_tbl}}

\item{column}{The column which supplies values to create the inline bar plot}

\item{category_column}{The category column, where a colored dot and bar will be added}

\item{palette}{The colors or color function that values will be mapped to. Can be a character vector (eg \code{c("white", "red")} or hex colors) or a named palette from the \code{{paletteer}} package.}

\item{max_value}{A single numeric value indicating the max value, if left as \code{NULL} then the range of the \code{column} values will be used}
}
\value{
a \code{gt_tbl}
}
\description{
This function takes a data column and a categorical column and
adds a colored dot and a colored dot to the categorical column. You can supply
a specific palette or a palette from the \code{{paletteer}} package.
}
\section{Examples}{


\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(gt)
dot_bar_tab <- mtcars \%>\%
  head() \%>\%
  dplyr::mutate(cars = sapply(strsplit(rownames(.)," "), `[`, 1)) \%>\%
  dplyr::select(cars, mpg, disp) \%>\%
  gt() \%>\%
  gt_plt_dot(disp, cars, palette = "ggthemes::fivethirtyeight") \%>\%
  cols_width(cars ~ px(125))
}\if{html}{\out{</div>}}
}

\section{Figures}{

\if{html}{\figure{gt_dot_bar.png}{options: width=50\%}}
}

\seealso{
Other Themes: 
\code{\link{gt_plt_bullet}()},
\code{\link{gt_plt_conf_int}()},
\code{\link{gt_theme_538}()},
\code{\link{gt_theme_dark}()},
\code{\link{gt_theme_dot_matrix}()},
\code{\link{gt_theme_espn}()},
\code{\link{gt_theme_excel}()},
\code{\link{gt_theme_guardian}()},
\code{\link{gt_theme_nytimes}()},
\code{\link{gt_theme_pff}()}
}
\concept{Themes}
