% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_trip_speed.R
\name{get_trip_speed}
\alias{get_trip_speed}
\title{Get trip speed}
\usage{
get_trip_speed(
  gtfs,
  trip_id = NULL,
  file = "shapes",
  unit = "km/h",
  sort_sequence = FALSE
)
}
\arguments{
\item{gtfs}{A GTFS object, as created by \code{\link[=read_gtfs]{read_gtfs()}}.}

\item{trip_id}{A character vector including the \code{trip_id}s to have their
speeds calculated. If \code{NULL} (the default), the function calculates the
speed of every \code{trip_id} in the GTFS.}

\item{file}{The file from which geometries should be generated, either
\code{shapes} or \code{stop_times} (geometries are used to calculate the length of a
trip). Defaults to \code{shapes}.}

\item{unit}{A string representing the unit in which the speeds are desired.
Either \code{"km/h"} (the default) or \code{"m/s"}.}

\item{sort_sequence}{Ultimately passed to \code{\link[=get_trip_length]{get_trip_length()}}, a logical
specifying whether to sort shapes and timetables by \code{shape_pt_sequence} and
\code{stop_sequence}, respectively. Speeds calculated from trip trajectories
generated with unordered sequences do not correctly depict the actual trip
speeds. Defaults to \code{FALSE}, otherwise spec-compliant feeds, in which
shape/timetables points are already ordered by
\code{shape_pt_sequence}/\code{stop_sequence}, would be penalized through longer
processing times.}
}
\value{
A \code{data.table} containing the duration of each specified trip and the
file from which geometries were generated.
}
\description{
Returns the speed of each specified \code{trip_id}, based on the geometry created
from either the \code{shapes} or the \code{stop_times} file (or both).
}
\section{Details}{

Please check \code{\link[=get_trip_geometry]{get_trip_geometry()}} documentation to understand how geometry
generation differs depending on the chosen file.
}

\examples{
data_path <- system.file("extdata/spo_gtfs.zip", package = "gtfstools")

gtfs <- read_gtfs(data_path)

trip_speed <- get_trip_speed(gtfs)
head(trip_speed)

trip_ids <- c("CPTM L07-0", "2002-10-0")
trip_speed <- get_trip_speed(gtfs, trip_ids)
trip_speed

trip_speed <- get_trip_speed(
  gtfs,
  trip_ids,
  file = c("shapes", "stop_times")
)
trip_speed

trip_speed <- get_trip_speed(gtfs, trip_ids, unit = "m/s")
trip_speed

}
\seealso{
\code{\link[=get_trip_geometry]{get_trip_geometry()}}
}
