% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmt_regression.R
\name{fmt_regression}
\alias{fmt_regression}
\title{Turn a regression model object into a markdown-ready tibble.}
\usage{
fmt_regression(x, exponentiate = FALSE, label = NULL,
  include = names(stats::model.frame(x)), show_yesno = NULL,
  conf.level = 0.95, intercept = FALSE, beta_fun = fmt_beta,
  pvalue_fun = fmt_pvalue)
}
\arguments{
\item{x}{regression model object}

\item{exponentiate}{logical argument passed directly to
\code{tidy} function
Default is \code{FALSE}}

\item{label}{list of labels to write in the output. \code{list(age60 = "Age > 60")}}

\item{include}{names of variables to include in output.  Default is all variables.}

\item{show_yesno}{Vector of names of categorical and factor variables that
are \code{c("No", "Yes")}, \code{c("no", "yes")}, or \code{c("NO", "YES")} default to dichotomous printing
(i.e. only Yes shown). To force both levels to be shown include the column
name in \code{show_yesno}, e.g. \code{show_yesno = c("highgrade", "female")}}

\item{conf.level}{confidence level passed directly to \code{tidy} function. Default is 0.95.}

\item{intercept}{logical argument indicates whether to include the intercept
in the output.  Default is \code{FALSE}}

\item{beta_fun}{function to round and format beta coefficients.  Default is \code{\link{fmt_beta}}}

\item{pvalue_fun}{function to round and format p-values.  Default is \code{\link{fmt_pvalue}}}
}
\description{
This function uses \code{broom::tidy} from the \code{broom} or \code{broom.mixed} packages
to perform the initial model formatting. Review the \code{fmt_regression} vignette
for detailed examples.
}
\examples{
mod1 <- lm(hp ~ mpg + factor(cyl), mtcars)
fmt_regression(mod1)

mod2 <- glm(response ~ age + grade + stage, trial, family = binomial(link = "logit"))
fmt_regression(mod2, exponentiate = TRUE)

library(lme4)
mod_glmer <- glmer(am ~ hp + (1 | gear), mtcars, family = binomial)
fmt_regression(mod_glmer, exponentiate = TRUE)
}
