% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_stat_label.R
\name{add_stat_label}
\alias{add_stat_label}
\title{Add statistic labels column}
\usage{
add_stat_label(x)
}
\arguments{
\item{x}{Object with class \code{tbl_summary} from the \link{tbl_summary} function}
}
\value{
A \code{tbl_summary} object
}
\description{
Adds a column with labels describing the summary statistics presented for
each variable in the \link{tbl_summary} table.
}
\section{Example Output}{

\if{html}{\figure{tbl_stat_ex.png}{options: width=50\%}}
}

\examples{
tbl_stat_ex <-
  trial \%>\%
  dplyr::select(trt, age, grade, response) \%>\%
  tbl_summary() \%>\%
  add_stat_label()
}
\seealso{
Other tbl_summary tools: \code{\link{add_n}},
  \code{\link{add_overall}}, \code{\link{add_p}},
  \code{\link{add_q.tbl_summary}},
  \code{\link{bold_italicize_labels_levels}},
  \code{\link{bold_p.tbl_summary}},
  \code{\link{inline_text.tbl_summary}},
  \code{\link{modify_header}},
  \code{\link{sort_p.tbl_summary}},
  \code{\link{tbl_summary}}
}
\author{
Daniel D. Sjoberg
}
\concept{tbl_summary tools}
