% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl_uvregression.R
\name{tbl_uvregression}
\alias{tbl_uvregression}
\title{Display univariate regression model results in table}
\usage{
tbl_uvregression(data, method, y, method.args = NULL,
  formula = "{y} ~ {x}", exponentiate = FALSE, label = NULL,
  include = NULL, exclude = NULL, hide_n = FALSE,
  show_single_row = NULL, conf.level = NULL, estimate_fun = NULL,
  pvalue_fun = NULL, show_yesno = NULL)
}
\arguments{
\item{data}{Data frame to be used in univariate regression modeling.  Data
frame includes the outcome variable(s) and the independent variables.}

\item{method}{Regression method (e.g. \link{lm}, \link{glm}, \link[survival:coxph]{survival::coxph}, and more).}

\item{y}{Model outcome (e.g. \code{y = recurrence} or \code{y = Surv(time, recur)})}

\item{method.args}{List of additional arguments passed on to the regression
function defined by \code{method}.}

\item{formula}{String of the model formula.
Uses \link[glue:glue]{glue::glue} syntax. Default is \code{"{y} ~ {x}"}, where \code{{y}}
is the dependent variable, and \code{{x}} represents a single covariate. For a
random intercept model, the formula may be \code{formula = "{y} ~ {x} + (1 | gear)"}.}

\item{exponentiate}{Logical indicating whether to exponentiate the
coefficient estimates. Default is \code{FALSE}.}

\item{label}{List of formulas specifying variables labels,
e.g. \code{list("age" ~ "Age, yrs", "ptstage" ~ "Path T Stage")}}

\item{include}{Character vector of variable names to include from output.}

\item{exclude}{Character vector of variable names to exclude from output.}

\item{hide_n}{Hide N column. Default is \code{FALSE}}

\item{show_single_row}{By default categorical variables are printed on
multiple rows.  If a variable is binary (e.g. Yes/No) and you wish to print
the regression coefficient on a single row, include the variable name here,
e.g. \code{show_single_row = c("var1", "var2")}}

\item{conf.level}{Must be strictly greater than 0 and less than 1.
Defaults to 0.95, which corresponds to a 95 percent confidence interval.}

\item{estimate_fun}{Function to round and format coefficient estimates.
Default is \link{style_sigfig} when the coefficients are not transformed, and
\link{style_ratio} when the coefficients have been exponentiated.}

\item{pvalue_fun}{Function to round and format p-values.
Default is \link{style_pvalue}.
The function must have a numeric vector input (the numeric, exact p-value),
and return a string that is the rounded/formatted p-value (e.g.
\code{pvalue_fun = function(x) style_pvalue(x, digits = 2)} or equivalently,
\code{purrr::partial(style_pvalue, digits = 2)}).}

\item{show_yesno}{deprecated}
}
\value{
A \code{tbl_uvregression} object
}
\description{
This function estimates univariate regression models and returns them in
a publication-ready table. The function takes as arguments a data frame,
the type of regression model, and the outcome variable. Each column in the
data frame is regressed on the specified outcome. The \code{tbl_uvregression}
function arguments are similar to the \link{tbl_regression} arguments. Review the
\href{http://www.danieldsjoberg.com/gtsummary/articles/tbl_regression.html#tbl_uvregression}{tbl_uvregression vignette}
for detailed examples.
}
\section{Example Output}{

\if{html}{Example 1}

\if{html}{\figure{tbl_uv_ex1.png}{options: width=50\%}}

\if{html}{Example 2}

\if{html}{\figure{tbl_uv_ex2.png}{options: width=50\%}}
}

\section{Setting Defaults}{

If you prefer to consistently use a different function to format p-values or
estimates, you can set options in the script or in the user- or
project-level startup file, '.Rprofile'.  The default confidence level can
also be set.
\itemize{
\item \code{options(gtsummary.pvalue_fun = new_function)}
\item \code{options(gtsummary.tbl_regression.estimate_fun = new_function)}
\item \code{options(gtsummary.conf.level = 0.90)}
}
}

\section{Note}{

The N reported in the output is the number of observations
in the data frame \code{model.frame(x)}. Depending on the model input, this N
may represent different quantities. In most cases, it is the number of people or
units in your model.  Here are some common exceptions.
\enumerate{
\item Survival regression models including time dependent covariates.
\item Random- or mixed-effects regression models with clustered data.
\item GEE regression models with clustered data.
}

This list is not exhaustive, and care should be taken for each number reported.
}

\examples{
tbl_uv_ex1 <-
  tbl_uvregression(
    trial \%>\% dplyr::select(response, age, grade),
    method = glm,
    y = response,
    method.args = list(family = binomial),
    exponentiate = TRUE
  )

# rounding pvalues to 2 decimal places
library(survival)
tbl_uv_ex2 <-
  tbl_uvregression(
    trial \%>\% dplyr::select(ttdeath, death, age, grade, response),
    method = coxph,
    y = Surv(ttdeath, death),
    label = list(vars(grade) ~ "Grade"),
    exponentiate = TRUE,
    pvalue_fun = function(x) style_pvalue(x, digits = 2)
  )

# for convenience, you can also pass named lists to any arguments
# that accept formulas (e.g label, etc.)
library(survival)
trial \%>\%
   dplyr::select(ttdeath, death, age, grade, response) \%>\%
   tbl_uvregression(
     method = coxph,
     y = Surv(ttdeath, death),
     label = list(grade = "Grade"),
     exponentiate = TRUE)

}
\seealso{
See tbl_regression \href{http://www.danieldsjoberg.com/gtsummary/articles/tbl_regression.html#tbl_uvregression}{vignette}  for detailed examples

Other tbl_uvregression tools: \code{\link{add_global_p.tbl_uvregression}},
  \code{\link{add_nevent.tbl_uvregression}},
  \code{\link{add_q.tbl_uvregression}},
  \code{\link{bold_italicize_labels_levels}},
  \code{\link{bold_p.tbl_stack}},
  \code{\link{bold_p.tbl_uvregression}},
  \code{\link{inline_text.tbl_uvregression}},
  \code{\link{modify_header}},
  \code{\link{sort_p.tbl_uvregression}},
  \code{\link{tbl_merge}}, \code{\link{tbl_stack}}
}
\author{
Daniel D. Sjoberg
}
\concept{tbl_uvregression tools}
