% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl_merge.R
\name{tbl_merge}
\alias{tbl_merge}
\title{Merge two or more gtsummary objects}
\usage{
tbl_merge(tbls, tab_spanner = NULL)
}
\arguments{
\item{tbls}{List of gtsummary objects to merge}

\item{tab_spanner}{Character vector specifying the spanning headers.
Must be the same length as \code{tbls}. The
strings are interpreted with \code{gt::md}.
Must be same length as \code{tbls} argument}
}
\value{
A \code{tbl_merge} object
}
\description{
Merges two or more \code{tbl_regression}, \code{tbl_uvregression}, \code{tbl_stack},
or \code{tbl_summary} objects and adds appropriate spanning headers.
}
\section{Example Output}{

\if{html}{Example 1}

\if{html}{\figure{tbl_merge_ex1.png}{options: width=70\%}}

\if{html}{Example 2}

\if{html}{\figure{tbl_merge_ex2.png}{options: width=65\%}}
}

\examples{
# Example 1 ----------------------------------
# Side-by-side Regression Models
library(survival)
t1 <-
  glm(response ~ trt + grade + age, trial, family = binomial) \%>\%
  tbl_regression(exponentiate = TRUE)
t2 <-
  coxph(Surv(ttdeath, death) ~ trt + grade + age, trial) \%>\%
  tbl_regression(exponentiate = TRUE)
tbl_merge_ex1 <-
  tbl_merge(
    tbls = list(t1, t2),
    tab_spanner = c("**Tumor Response**", "**Time to Death**")
  )

# Example 2 ----------------------------------
# Descriptive statistics alongside univariate regression, with no spanning header
t3 <-
  trial[c("age", "grade", "response")] \%>\%
  tbl_summary(missing = "no") \%>\%
  add_n \%>\%
  modify_header(stat_0 ~ "**Summary Statistics**")
t4 <-
  tbl_uvregression(
    trial[c("ttdeath", "death", "age", "grade", "response")],
    method = coxph,
    y = Surv(ttdeath, death),
    exponentiate = TRUE,
    hide_n = TRUE
  )

tbl_merge_ex2 <-
  tbl_merge(tbls = list(t3, t4)) \%>\%
  modify_spanning_header(everything() ~ NA_character_)

}
\seealso{
\link{tbl_stack}

Other tbl_regression tools: 
\code{\link{add_global_p.tbl_regression}()},
\code{\link{add_nevent.tbl_regression}()},
\code{\link{add_q}()},
\code{\link{bold_italicize_labels_levels}},
\code{\link{combine_terms}()},
\code{\link{inline_text.tbl_regression}()},
\code{\link{modify_footnote}()},
\code{\link{modify_header}()},
\code{\link{modify_spanning_header}()},
\code{\link{tbl_regression}()},
\code{\link{tbl_stack}()}

Other tbl_uvregression tools: 
\code{\link{add_global_p.tbl_uvregression}()},
\code{\link{add_nevent.tbl_uvregression}()},
\code{\link{add_q}()},
\code{\link{bold_italicize_labels_levels}},
\code{\link{inline_text.tbl_uvregression}()},
\code{\link{modify_footnote}()},
\code{\link{modify_header}()},
\code{\link{modify_spanning_header}()},
\code{\link{tbl_stack}()},
\code{\link{tbl_uvregression}()}

Other tbl_summary tools: 
\code{\link{add_n}()},
\code{\link{add_overall}()},
\code{\link{add_p.tbl_summary}()},
\code{\link{add_q}()},
\code{\link{add_stat_label}()},
\code{\link{bold_italicize_labels_levels}},
\code{\link{inline_text.tbl_summary}()},
\code{\link{inline_text.tbl_survfit}()},
\code{\link{modify_footnote}()},
\code{\link{modify_header}()},
\code{\link{modify_spanning_header}()},
\code{\link{tbl_stack}()},
\code{\link{tbl_summary}()}
}
\author{
Daniel D. Sjoberg
}
\concept{tbl_regression tools}
\concept{tbl_summary tools}
\concept{tbl_uvregression tools}
