% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_significance_stars.R
\name{add_significance_stars}
\alias{add_significance_stars}
\title{Add significance stars}
\usage{
add_significance_stars(
  x,
  pattern = "{estimate}{stars}",
  thresholds = c(0.001, 0.01, 0.05),
  hide_ci = TRUE,
  hide_p = TRUE,
  hide_se = FALSE
)
}
\arguments{
\item{x}{a \code{'tbl_regression'} or \code{'tbl_uvregression'} object}

\item{pattern}{glue-syntax string indicating what to display in formatted column.
Default is \code{"{estimate}{stars}"}. Other common patterns are
\code{"{estimate}{stars} ({conf.low}, {conf.high})"} and
\code{"{estimate} ({conf.low} to {conf.high}){stars}"}}

\item{thresholds}{thresholds for significance stars. Default is \code{c(0.001, 0.01, 0.05)}}

\item{hide_ci}{logical whether to hide confidence interval. Default is \code{TRUE}}

\item{hide_p}{logical whether to hide p-value. Default is \code{TRUE}}

\item{hide_se}{logical whether to hide standard error. Default is \code{FALSE}}
}
\description{
\lifecycle{experimental}
Add significance stars to estimates with small p-values
}
\section{Future Updates}{

There are planned updates to the implementation of this function
with respect to the \verb{pattern=} argument.
Currently, this function replaces the numeric estimate column, with a
formatted character column following \verb{pattern=}.
Once \code{gt::cols_merge()} gains the \verb{rows=} argument the
implementation will be updated to use it, which will keep
numeric columns numeric. For the \emph{vast majority} of users,
\emph{the planned change will be go unnoticed}.
}

\section{Example Output}{

\if{html}{Example 1}

\if{html}{\figure{add_significance_stars_ex1.png}{options: width=45\%}}

\if{html}{Example 2}

\if{html}{\figure{add_significance_stars_ex2.png}{options: width=35\%}}

\if{html}{Example 3}

\if{html}{\figure{add_significance_stars_ex3.png}{options: width=30\%}}
}

\examples{
tbl <-
  lm(time ~ ph.ecog + sex, survival::lung) \%>\%
  tbl_regression(label = list(ph.ecog = "ECOG Score", sex = "Sex"))

# Example 1 ----------------------------------
add_significance_stars_ex1 <-
  tbl \%>\%
  add_significance_stars(hide_ci = FALSE, hide_p = FALSE)

# Example 2 ----------------------------------
add_significance_stars_ex2 <-
  tbl \%>\%
  add_significance_stars(
    pattern = "{estimate} ({conf.low}, {conf.high}){stars}",
    hide_ci = TRUE, hide_se = TRUE
  ) \%>\%
  modify_header(estimate ~ "**Beta (95\% CI)**") \%>\%
  modify_footnote(estimate ~ "CI = Confidence Interval", abbreviation = TRUE)

# Example 3 ----------------------------------
# Use <br> to put a line break between beta and SE in HTML output
add_significance_stars_ex3 <-
  tbl \%>\%
  add_significance_stars(
    hide_se = TRUE,
    pattern = "{estimate}{stars}<br>({std.error})"
  ) \%>\%
  modify_header(estimate ~ "**Beta (SE)**") \%>\%
  modify_footnote(estimate ~ "SE = Standard Error", abbreviation = TRUE) \%>\%
  as_gt() \%>\%
  gt::tab_style(
    style = "vertical-align:top",
    locations = gt::cells_body(columns = vars(label))
  )
}
