% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify_post_fmt_fun.R
\name{modify_post_fmt_fun}
\alias{modify_post_fmt_fun}
\title{Modify post formatting}
\usage{
modify_post_fmt_fun(x, fmt_fun, columns, rows = TRUE)
}
\arguments{
\item{x}{(\code{gtsummary})\cr
A gtsummary object}

\item{fmt_fun}{(\code{function})\cr
a function that will be applied to the specified columns and rows.}

\item{columns}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
Selector of columns in \code{x$table_body}}

\item{rows}{(predicate \code{expression})\cr
Predicate expression to select rows in \code{x$table_body}.
Review \link[=rows_argument]{rows argument details}.}
}
\value{
Updated gtsummary object
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}\cr
Apply a formatting function after the primary formatting functions have been applied.
The function is similar to \code{gt::text_transform()}.
}
\examples{
# Example 1 ----------------------------------
data.frame(x = FALSE) |>
  tbl_summary(type = x ~ "categorical") |>
  modify_post_fmt_fun(
    fmt_fun = ~ifelse(. == "0 (0\%)", "0", .),
    columns = all_stat_cols()
  )
}
