% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gwer.multiscale.diag.R
\name{gwer.multiscale.diag}
\alias{gwer.multiscale.diag}
\title{Diagnostic for Geographically Weighted Elliptical Regression Models}
\usage{
gwer.multiscale.diag(object, ...)
}
\arguments{
\item{object}{an object with the result of the fitted multiscale geographically weighted elliptical regression model.}

\item{...}{arguments to be used to form the default control argument if it is not supplied directly.}
}
\value{
Returns a list of diagnostic arrays:
\item{ro}{ordinal residuals.}
\item{rr}{response residuals.}
\item{rp}{pearson residuals.}
\item{rs}{studentized residuals.}
\item{rd}{deviance residuals.}
\item{dispersion}{coefficient of dispersion parameter.}
\item{Hat}{the hat matrix.}
\item{h}{main diagonal of the hat matrix.}
\item{GL}{generalized leverage.}
\item{GLbeta}{generalized leverage of location parameters estimation.}
\item{GLphi}{generalized leverage of dispersion parameters estimation.}  
\item{DGbeta}{cook distance of location parameters estimation.}
\item{DGphi}{cook distance of dispersion parameters estimation.}  
\item{Cic}{normal curvature for case-weight perturbation.}
\item{Cih}{normal curvature for scale perturbation.}
\item{Lmaxr}{local influence on response (additive perturbation in responce).}
\item{Lmaxc}{local influence on coefficients (additive perturbation in predictors).}
}
\description{
This function obtains the values of different residuals types and calculates the diagnostic measures for the fitted geographically weighted elliptical regression model.
}
\examples{
\donttest{
data(georgia, package = "spgwr")
fit.formula <- PctBach ~ TotPop90 + PctRural + PctFB + PctPov
gwer.bw.t <- bw.gwer(fit.formula, data = gSRDF, family = Student(3), adapt = TRUE)
msgwr.fit.t <- gwer.multiscale(fit.formula, family = Student(3), data = gSRDF, 
                               bws0 = rep(gwer.bw.t, 5), hatmatrix = TRUE, 
                               adaptive = TRUE)
gwer.multiscale.diag(msgwr.fit.t)
}
}
\references{
Brunsdon, C., Fotheringham, A. S. and Charlton, M. E. (1996). 
Geographically weighted regression: a method for exploring spatial nonstationarity.
Geographical analysis, 28(4), 281-298. \doi{10.1111/j.1538-4632.1996.tb00936.x}

Galea, M., Paula, G. A., and Cysneiros, F. J. A. (2005). On diagnostics in 
symmetrical nonlinear models. Statistics & Probability Letters, 73(4), 459-467.
\doi{10.1016/j.spl.2005.04.033}
}
\seealso{
\code{\link{elliptical}}
}
\keyword{Diagnostic}
\keyword{Elliptical}
\keyword{Geographically}
\keyword{Multiscale}
\keyword{Regression}
\keyword{Weighted}
\keyword{methods}
\keyword{models}
