% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{buildItem}
\alias{buildItem}
\alias{buildOneItem}
\title{Build a model suitable for a single item genome-wide association study}
\usage{
buildItem(
  phenoData,
  depVar,
  covariates = NULL,
  ...,
  fitfun = c("WLS", "ML"),
  minMAF = 0.01,
  gxe = NULL,
  exogenous = NA,
  pred = "snp"
)
}
\arguments{
\item{phenoData}{the file pathway for the phenotypic data (e.g. "myData.txt" or 
"phenotype/myData.txt"). This data file can include more variables than 
those included in the analysis, but GW-SEM will only use the items/covariates 
that are specified. (The dangers of very large dataset is that they can take 
a long time to load and can take up space in the R environment. This should 
not affect processing speed for the GWAS analysis, but can create headaches 
for pre-processing).}

\item{depVar}{the name of items to predict}

\item{covariates}{a character list of covariates that the latent variable 
will be regressed upon. The default vaule is NULL, but this is a 
silly value as typically analysts will include e.g. age, sex, and 
ancestry principle components in the analysis.}

\item{...}{Not used.  Forces remaining arguments to be specified by name.}

\item{fitfun}{The fitfun argument specifies which fit function should 
be used in evaluating the GWAS model. Users may choose between 
the relatively rapid "WLS", or the slower but asymptotically 
optimal "ML". In many cases the the differences between the 
fit functions is trivial and the faster "WLS" option should be 
used, but in some situations the differences can be quite 
meaningful (such as when data are Missing at Random - MAR).}

\item{minMAF}{The minimum valid minor allele frequency (MAF). Large differences between the variances of two variables in the same model can cause optimization failures that invalidate the model. Further, very small minor allele frequencies are more affected by outliers or influential observations. Accordingly, users can specify the minimum allowable MAF. The default value is MAF > .01. Users may also wish to filter out small MAF alleles from their genotype files in other software programs, such as PLINK.}

\item{gxe}{The observed variable name that will be used to moderate (interact with) 
the effect of the SNP on the phenotypes. For example, you may want to moderate 
the SNP regression by sex. In this situation, you would specify gxe = "sex" and 
add "snp_sex" to the list of covariates.}

\item{exogenous}{This argument specifies how you would like to integrate 
the covariates into the analysis. If exogenous = T, each items will 
be directly regressed on each covariate. If exogenous = F, the latent 
factor(s) will be directly regressed on each covariate. Setting 
exogenous = T does not assume that the items are related to the 
covariates proportional to their factor loadings (which is probably 
preferable in most cases).}

\item{pred}{character vector of variables that predict the phenotype(s). These predictors are always endogenous to the model (unaffected by the `exogenous` option).}
}
\value{
A \link[OpenMx:MxModel-class]{MxModel}
}
\description{
\lifecycle{maturing}
}
\details{
You can pass the result of this function to \link{GWAS} to run a GWAS.

Ordinal indicator thresholds are setup by
\link{setupThresholds}.
You can plot the model using \link[OpenMx]{omxGraphviz}.
}
\section{WLS Technical Note}{

When the \code{depVar} item is/are continuous,
covariates are endogenous (the default),
and the fit function is \code{WLS} then the
\code{cumulants} method is used to create observed summary
statistics (see \link[OpenMx]{mxFitFunctionWLS}). In other cases,
the \code{marginals} method is used. The \code{cumulants} method is
more accurate than \code{marginals}. The difference in accuracy
becomes vivid when comparing estimates against the \code{ML} fit
function.
}

\examples{
pheno <- data.frame(anxiety=cut(rnorm(500), c(-Inf, -.5, .5, Inf),
                    ordered_result = TRUE))
m1 <- buildItem(pheno, 'anxiety')
}
\seealso{
Other model builder: 
\code{\link{buildOneFacRes}()},
\code{\link{buildOneFac}()},
\code{\link{buildTwoFac}()}
}
\concept{model builder}
