% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{buildTwoFac}
\alias{buildTwoFac}
\title{Build a model suitable for a two factor genome-wide association study}
\usage{
buildTwoFac(
  phenoData,
  F1itemNames,
  F2itemNames,
  covariates = NULL,
  ...,
  fitfun = c("WLS", "ML"),
  minMAF = 0.01,
  gxe = NULL,
  exogenous = NA,
  pred = "snp"
)
}
\arguments{
\item{phenoData}{a data.table containing the phenotypic data. Can
include more variables than those included in the analysis, but
GW-SEM will only use the items/covariates that are specified in
the model.}

\item{F1itemNames}{a character list of the names of the items that load 
onto the first latent variable. These names must match variable names 
in the phenoData file.}

\item{F2itemNames}{a character list of the names of the items that load 
onto the first latent variable. These names must match variable names 
in the phenoData file.}

\item{covariates}{a character list of covariates that the latent variable 
will be regressed upon. The default vaule is NULL, but this is a 
silly value as typically analysts will include e.g. age, sex, and 
ancestry principle components in the analysis.}

\item{...}{Not used.  Forces remaining arguments to be specified by name.}

\item{fitfun}{The fitfun argument specifies which fit function should 
be used in evaluating the GWAS model. Users may choose between 
the relatively rapid "WLS", or the slower but asymptotically 
optimal "ML". In many cases the the differences between the 
fit functions is trivial and the faster "WLS" option should be 
used, but in some situations the differences can be quite 
meaningful (such as when data are Missing at Random - MAR).}

\item{minMAF}{The minimum valid minor allele frequency (MAF). Large differences between the variances of two variables in the same model can cause optimization failures that invalidate the model. Further, very small minor allele frequencies are more affected by outliers or influential observations. Accordingly, users can specify the minimum allowable MAF. The default value is MAF > .01. Users may also wish to filter out small MAF alleles from their genotype files in other software programs, such as PLINK.}

\item{gxe}{The observed variable name that will be used to moderate (interact with) 
the effect of the SNP on the phenotypes. For example, you may want to moderate 
the SNP regression by sex. In this situation, you would specify gxe = "sex" and 
add "snp_sex" to the list of covariates.}

\item{exogenous}{This argument specifies how you would like to integrate 
the covariates into the analysis. If exogenous = T, each items will 
be directly regressed on each covariate. If exogenous = F, the latent 
factor(s) will be directly regressed on each covariate. Setting 
exogenous = T does not assume that the items are related to the 
covariates proportional to their factor loadings (which is probably 
preferable in most cases).}

\item{pred}{character vector of variables that predict the phenotype(s). These predictors are always endogenous to the model (unaffected by the `exogenous` option).}
}
\value{
\code{buildTwoFac} returns an \link[OpenMx:MxModel-class]{MxModel} object that can serve as input for the \link{GWAS} function.
}
\description{
\lifecycle{maturing}
The buildTwoFac function is used to specify a model with two latent variables where each latent variable is simultaneously predicted by a genomic variant such as a single nucleotide polymorphism, as well as range of covariates. The model allows the latent variables to correlate to accomodate comorbidity between latent traits. \figure{twoFactor.jpg}{Two Factor Model}
}
\details{
You can pass the result of this function to \link{GWAS} to run a GWAS.

Ordinal indicator thresholds are setup by
\link{setupThresholds}.
You can plot the model using \link[OpenMx]{omxGraphviz}.
}
\examples{
pheno <- list()
for (i in 1:10) pheno[[paste0('i',i)]] <- rnorm(500)
pheno <- as.data.frame(pheno)
buildTwoFac(pheno, paste0('i',1:6), paste0('i',5:10))
}
\seealso{
Other model builder: 
\code{\link{buildItem}()},
\code{\link{buildOneFacRes}()},
\code{\link{buildOneFac}()}
}
\concept{model builder}
