% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tiling.R
\encoding{UTF-8}
\name{hreflection}
\alias{hreflection}
\title{Hyperbolic reflection}
\usage{
hreflection(A, B, M)
}
\arguments{
\item{A, B}{two points in the Poincaré disk defining the reflection line}

\item{M}{a point in the Poincaré disk to be reflected}
}
\value{
A point in the Poincaré disk, the image of \code{M} by the
  hyperbolic reflection with respect to the line passing through
  \code{A} and \code{B}.
}
\description{
Hyperbolic reflection in the Poincaré disk.
}
\examples{
library(gyro)
library(plotrix)
A <- c(0.45, 0.78)
B <- c(0.1, -0.5)
M <- c(0.7, 0)
opar <- par(mar = c(0, 0, 0, 0))
plot(NULL, type = "n", xlim = c(-1, 1), ylim = c(-1, 1), asp = 1,
     axes = FALSE, xlab = NA, ylab = NA)
draw.circle(0, 0, radius = 1, lwd = 2)
lines(gyrosegment(A, B, model = "M"))
points(rbind(A, B), pch = 19)
points(rbind(M), pch = 19, col = "blue")
P <- hreflection(A, B, M)
points(rbind(P), pch = 19, col = "red")
par(opar)
}
