% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{h2o.cluster_sizes}
\alias{h2o.cluster_sizes}
\title{Retrieve the cluster sizes}
\usage{
h2o.cluster_sizes(object, train = FALSE, valid = FALSE, xval = FALSE)
}
\arguments{
\item{object}{An \linkS4class{H2OClusteringModel} object.}

\item{train}{Retrieve the training cluster sizes}

\item{valid}{Retrieve the validation cluster sizes}

\item{xval}{Retrieve the cross-validation cluster sizes}
}
\description{
Retrieve the cluster sizes.
If "train", "valid", and "xval" parameters are FALSE (default), then the training cluster sizes value is returned. If more
than one parameter is set to TRUE, then a named list of cluster size vectors are returned, where the names are "train", "valid"
or "xval".
}
\examples{
\dontrun{
library(h2o)
h2o.init()
fr <- h2o.importFile("http://h2o-public-test-data.s3.amazonaws.com/smalldata/iris/iris_train.csv")
predictors <- c("sepal_len", "sepal_wid", "petal_len", "petal_wid")
km <- h2o.kmeans(x = predictors, training_frame = fr, k = 3, nfolds = 3)
h2o.cluster_sizes(km, train = TRUE)
}
}
