% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{h2o.cross_validation_fold_assignment}
\alias{h2o.cross_validation_fold_assignment}
\title{Retrieve the cross-validation fold assignment}
\usage{
h2o.cross_validation_fold_assignment(object)
}
\arguments{
\item{object}{An \linkS4class{H2OModel} object.}
}
\value{
Returns a H2OFrame
}
\description{
Retrieve the cross-validation fold assignment
}
\examples{
\dontrun{
library(h2o)
h2o.init()

f <- "https://s3.amazonaws.com/h2o-public-test-data/smalldata/junit/cars_20mpg.csv"
cars <- h2o.importFile(f)
cars["economy_20mpg"] <- as.factor(cars["economy_20mpg"])
predictors <- c("displacement", "power", "weight", "acceleration", "year")
response <- "economy_20mpg"
cars_split <- h2o.splitFrame(data = cars, ratios = 0.8, seed = 1234)
train <- cars_split[[1]]
valid <- cars_split[[2]]
cars_gbm <- h2o.gbm(x = predictors, y = response, training_frame = train,
                    nfolds = 5,  keep_cross_validation_fold_assignment = TRUE, seed = 1234)
h2o.cross_validation_fold_assignment(cars_gbm)
}
}
