% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hBayesDM.R
\docType{package}
\name{hBayesDM-package}
\alias{hBayesDM-package}
\alias{hBayesDM}
\title{Hierarchical Bayesian Modeling of Decision-Making Tasks}
\description{
Fit an array of decision-making tasks with computational models in a hierarchical Bayesian framework. Can perform hierarchical Bayesian analysis of various computational models with a single line of coding.
Bolded tasks, followed by their respective models, are itemized below.  

\describe{
 \item{\strong{Bandit}}{2-Armed Bandit (Rescorla-Wagner (delta)) --- \link{bandit2arm_delta} \cr
                        4-Armed Bandit with fictive updating + reward/punishment sensitvity (Rescorla-Wagner (delta)) --- \link{bandit4arm_4par} \cr
                        4-Armed Bandit with fictive updating + reward/punishment sensitvity + lapse (Rescorla-Wagner (delta)) --- \link{bandit4arm_lapse}}
 \item{\strong{Delay Discounting}}{Constant Sensitivity --- \link{dd_cs} \cr
                                   Constant Sensitivity for single subject --- \link{dd_cs_single} \cr
                                   Exponential --- \link{dd_exp} \cr
                                   Hyperbolic --- \link{dd_hyperbolic} \cr
                                   Hyperbolic for single subject --- \link{dd_hyperbolic_single}}
 \item{\strong{Orthogonalized Go/Nogo}}{RW + Noise --- \link{gng_m1} \cr
                                        RW + Noise + Bias --- \link{gng_m2} \cr
                                        RW + Noise + Bias + Pavlovian Bias --- \link{gng_m3} \cr
                                        RW(modified) + Noise + Bias + Pavlovian Bias --- \link{gng_m4}}
 \item{\strong{Iowa Gambling}}{Prospect Valence Learning-DecayRI --- \link{igt_pvl_decay} \cr
                               Prospect Valence Learning-Delta --- \link{igt_pvl_delta} \cr
                               Value-Plus_Perseverance --- \link{igt_vpp}}
 \item{\strong{Peer influence task}}{OCU model --- \link{peer_ocu}}
 \item{\strong{Probabilistic Reversal Learning}}{Fictitious Update --- \link{prl_fictitious} \cr
                                                 Fictitious Update and multiple blocks per subject --- \link{prl_fictitious_multipleB} \cr
                                                 Experience-Weighted Attraction --- \link{prl_ewa} \cr
                                                 Reward-Punishment --- \link{prl_rp} \cr
                                                 Reward-Punishment and multiple blocks per subject --- \link{prl_rp_multipleB} \cr
                                                 Fictitious Update with separate learning for Reward-Punishment --- \link{prl_fictitious_rp}}
 \item{\strong{Risk Aversion}}{Prospect Theory (PT) --- \link{ra_prospect} \cr
                               PT without a loss aversion parameter --- \link{ra_noLA} \cr
                               PT without a risk aversion parameter --- \link{ra_noRA}}
 \item{\strong{Ultimatum Game}}{Ideal Bayesian Observer --- \link{ug_bayes} \cr
                                Rescorla-Wagner (delta) --- \link{ug_delta}}
 \item{\strong{Choice/Reaction time}}{Drift Diffusion Model --- \link{choiceRT_ddm} \cr
                                      Drift Diffusion Model for single subject --- \link{choiceRT_ddm_single} \cr
                                      Linear Ballistic Accumulator --- \link{choiceRT_lba} \cr
                                      Linear Ballistic Accumulator for single subject --- \link{choiceRT_lba_single}}
}
}
\references{
Please cite as: 
Ahn, W.-Y., Haines, N., & Zhang, L. (2017). Revealing neuro-computational mechanisms of reinforcement learning and decision-making with the hBayesDM package. \emph{Computational Psychiatry}. 1:1. https://doi.org/10.1101/064287
}
\seealso{
For tutorials and further readings, visit : \url{http://rpubs.com/CCSL/hBayesDM}.
}
\author{
Woo-Young Ahn \email{wooyoung.ahn@gmail.com}

Nathaniel Haines \email{haines.175@osu.edu}

Lei Zhang \email{bnuzhanglei2008@gmail.com}
}
