% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dem_sample.R
\name{dem_sample}
\alias{dem_sample}
\title{Sample a random DEM with specified size from a larger DEM}
\usage{
dem_sample(data, L, allow_NA = TRUE, plot = FALSE, max_iter = 100)
}
\arguments{
\item{data}{Digital elevation model of class RasterLayer.}

\item{L}{Size of square to cut out of DEM.}

\item{allow_NA}{Logical. Allow NAs in the sample? Useful when DEM is not regular.}

\item{plot}{Logical. Plot the DEM and the cropped section?}

\item{max_iter}{Maximum number of random crops to try when allow_NA = FALSE before failing.}
}
\value{
Digital elevation model of class RasterLayer.
}
\description{
Sample a random DEM with specified size from a larger DEM
}
\note{
Not allowing NAs may increase sampling time for irregular DEMs that contain a lot of NAs; e.g., structure from motion transects.
}
\examples{
dem <- dem_sample(horseshoe, L = 2, plot=TRUE)

}
