% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fd_boxes.R
\name{fd_boxes}
\alias{fd_boxes}
\title{Calculate fractal dimension using the box counting method}
\usage{
fd_boxes(data, lvec, keep_data = FALSE, plot = FALSE)
}
\arguments{
\item{data}{A data frame in which the first two columns are x and y coordinates, respectively.}

\item{lvec}{The scales to use for calculation (i.e. box sizes).}

\item{keep_data}{Logical. Keep calculation data? Default = TRUE.}

\item{plot}{Logical. Plot the shape with box sizes superimposed? Defaults to FALSE.}
}
\value{
A value for fractal dimension, typically between 1 and 2 or a list if keep_data = TRUE.
}
\description{
Calculate fractal dimension using the box counting method
}
\details{
This function calculates fractal dimension using the box counting method.
If \code{lvec} is not specified, a default based on resolution and extent will be used.
Based on lvec, boxes of different sizes are defined and the function counts boxes that capture the outline of the shape.
It is recommended to specify the maximum value of \code{lvec} so that the largest
box encapsulates the entire object. The smallest scale included in \code{lvec}
should not be smaller than the resolution of your object.
}
\examples{
mcap_2d <- mesh_to_2d(mcap)

fd_boxes(mcap_2d, plot = TRUE, keep_data = TRUE)
fd_boxes(mcap_2d, lvec = c(0.05, 0.1, 0.2, 0.4), plot = TRUE)

}
