% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_model.R
\name{get_credible_intervals}
\alias{get_credible_intervals}
\title{Get Credible Intervals}
\usage{
get_credible_intervals(model, interval_min = 0.05, interval_max = 0.95)
}
\arguments{
\item{model}{A model output by \code{\link[=fit_model]{fit_model()}}}

\item{interval_min}{The lower bound for the credible interval. The number
must be between 0 and 1.}

\item{interval_max}{The upper bound for the credible interval. The number
must be greater than \code{interval_min} and must be less than 1.}
}
\value{
A list of data frames. Each data frame lists the credible intervals for a single writer.
}
\description{
In a model created with \code{\link[=fit_model]{fit_model()}} the pi parameters are the estimate of
the true cluster fill count for a particular writer and cluster. The function
\code{get_credible_intervals()} calculates the credible intervals of the pi
parameters for each writer in the model.
}
\examples{
get_credible_intervals(model=example_model)
get_credible_intervals(model=example_model, interval_min=0.05, interval_max=0.95)

}
