% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_est.R
\name{get_est}
\alias{get_est}
\title{Extract summaries of marginal posterior distributions from an HBAM model}
\usage{
get_est(
  object,
  par = "theta",
  probs = c(0.025, 0.5, 0.975),
  simplify = TRUE,
  ...
)
}
\arguments{
\item{object}{An instance of class \code{stanfit} produced by \code{hbam}.}

\item{par}{Character: Name of the parameter type to be extracted. Typically \code{"theta"} (stimuli positions) or \code{"chi"} (respondent positions).}

\item{probs}{A numeric vector of quantiles of interest. The default is c(0.025, 0.50, 0.975).}

\item{simplify}{Logical: Should the returned object be simplified by dropping the Monte Carlo standard error and the posterior standard deviation? Defaults to \code{TRUE}.}

\item{...}{Other arguments are passed on to \code{rstan::summary}.}
}
\value{
A tibble containing summaries of marginal posterior distributions.
}
\description{
This function is a wrapper for wrapper for \code{rstan::summary}.
}
