% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regWO_data_frame.R
\name{regWO.data.frame}
\alias{regWO.data.frame}
\title{Win odds regression using a data frame}
\usage{
\method{regWO}{data.frame}(x, AVAL, TRTP, COVAR, ref, alpha = 0.05, WOnull = 1, ...)
}
\arguments{
\item{x}{a data frame containing subject-level data.}

\item{AVAL}{variable in the data with ordinal analysis values.}

\item{TRTP}{the treatment variable in the data.}

\item{COVAR}{a numeric covariate.}

\item{ref}{the reference treatment group.}

\item{alpha}{significance level. The default is 0.05.}

\item{WOnull}{the null hypothesis. The default is 1.}

\item{...}{additional parameters.}
}
\value{
a data frame containing the win odds and its confidence interval. The data frame has an attribute called "covar_info" giving summary statistics for the covariate used for the calculations. The data frame itselfs contains the following columns:
\itemize{
\item WO_beta adjusted win odds.
\item LCL lower confidence limit for adjusted WO.
\item UCL upper confidence limit for adjusted WO.
\item SE standard error of the adjusted win odds.
\item WOnull win odds of the null hypothesis (specified in the \code{WOnull} argument).
\item alpha two-sided significance level for calculating the confidence interval (specified in the \code{alpha} argument).
\item Pvalue p-value associated with testing the null hypothesis.
\item beta adjusted win probability.
\item SE_beta standard error for the adjusted win probability.
\item WP (non-adjusted) win probability.
\item SE_WP standard error of the non-adjusted win probability.
\item WO non-adjusted win odds.
}
}
\description{
Win odds regression using a data frame
}
\examples{
# A baseline covariate that is highly correlated with the outcome
set.seed(2023)
dat <- COVID19
n <- nrow(dat)
dat$Severity <- ifelse(dat$GROUP > 4, rexp(n, 1), rexp(n, 10))
res <- regWO(x = dat, AVAL = "GROUP", TRTP = "TRTP", COVAR = "Severity", ref = "Placebo")
res
attr(res, "covar_info")
}
\references{
Gasparyan, Samvel B., et al. "Adjusted win ratio with stratification: calculation methods and interpretation." Statistical Methods in Medical Research 30.2 (2021): 580-611. \url{doi:10.1177/0962280220942558}
}
\seealso{
\code{\link[=regWO]{regWO()}}.
}
