% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hdMTD_CUT.R
\name{hdMTD_CUT}
\alias{hdMTD_CUT}
\title{The CUT method for inference in MTD models}
\usage{
hdMTD_CUT(
  X,
  d,
  S = 1:d,
  alpha = 0.05,
  mu = 1,
  xi = 0.5,
  A = NULL,
  warning = FALSE,
  ...
)
}
\arguments{
\item{X}{A vector or single-column data frame containing a chain sample (\code{X[1]} is the most recent).}

\item{d}{A positive integer representing an upper bound for the chain order.}

\item{S}{A numeric vector of distinct positive integers from which this function will select
a set of relevant lags. Should be a subset of \code{1:d}. Default is \code{1:d}.}

\item{alpha}{A positive real number used in the CUT threshold (which determines if two
distributions can be considered different). The larger the \code{alpha}, the greater
the distance required to consider that there is a difference between a set of distributions.}

\item{mu}{A positive real number such that \eqn{\code{mu}>(e^{\code{mu}}-1)/2}. \code{mu}
is also a component of the same threshold as \code{alpha}.}

\item{xi}{A positive real number, \code{xi} is also a component of the same threshold as
\code{alpha}.}

\item{A}{A vector with positive integers representing the state space. If not informed,
this function will set \code{A <- sort(unique(X))}.}

\item{warning}{Logical. If \code{TRUE}, the function warns the user when \code{A} is set automatically.}

\item{...}{Additional arguments (not used in this function, but maintained for compatibility with \code{\link[=hdMTD]{hdMTD()}}.}
}
\value{
Returns a set of relevant lags estimated using the CUT algorithm.
}
\description{
A function that estimates the set of relevant lags of an MTD model using the CUT method.
}
\details{
The "Forward Stepwise and Cut" (FSC) is an algorithm for inference in
Mixture Transition Distribution (MTD) models. It consists
in the application of the "Forward Stepwise" (FS) step followed by the CUT algorithm.
This method and its steps where developed by \href{http://jmlr.org/papers/v24/22-0266.html}{Ost and Takahashi}
and are specially useful for inference in high-order MTD Markov chains. This specific function
will only apply the CUT step of the algorithm and return an estimated relevant lag set.
}
\examples{
X <- testChains[,3]
hdMTD_CUT(X,4,alpha=0.02,mu=1,xi=0.4)
hdMTD_CUT(X,d=6,S=c(1,4,6),alpha=0.0065)

}
\references{
Ost, G. & Takahashi, D. Y. (2023).
Sparse Markov models for high-dimensional inference.
\emph{Journal of Machine Learning Research}, \emph{24}(279), 1-54.
\url{http://jmlr.org/papers/v24/22-0266.html}
}
