% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mus.R
\name{mus}
\alias{mus}
\title{Matrix Uncertainty Selector}
\usage{
mus(W, y, lambda = NULL, delta = NULL)
}
\arguments{
\item{W}{Design matrix, measured with error. Must be a numeric matrix.}

\item{y}{Vector of responses.}

\item{lambda}{Regularization parameter.}

\item{delta}{Additional regularization parameter, bounding the measurement error.}
}
\value{
An object of class "gmus".
}
\description{
Matrix Uncertainty Selector for linear regression.
}
\details{
This function is just a
wrapper for \code{gmus(W, y, lambda, delta, family = "gaussian")}.
}
\examples{
# Example with Gaussian response
set.seed(1)
# Number of samples
n <- 100
# Number of covariates
p <- 50
# True (latent) variables
X <- matrix(rnorm(n * p), nrow = n)
# Measurement matrix (this is the one we observe)
W <- X + matrix(rnorm(n*p, sd = 1), nrow = n, ncol = p)
# Coefficient vector
beta <- c(seq(from = 0.1, to = 1, length.out = 5), rep(0, p-5))
# Response
y <- X \%*\% beta + rnorm(n, sd = 1)
# Run the MU Selector
fit1 <- mus(W, y)
# Draw an elbow plot to select delta
plot(fit1)
coef(fit1)

# Now, according to the "elbow rule", choose the final delta where the curve has an "elbow".
# In this case, the elbow is at about delta = 0.08, so we use this to compute the final estimate:
fit2 <- mus(W, y, delta = 0.08)
plot(fit2) # Plot the coefficients
coef(fit2)
coef(fit2, all = TRUE)

}
\references{
\insertRef{rosenbaum2010}{hdme}

\insertRef{sorensen2018}{hdme}
}
