% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare-values.R
\name{compare_values}
\alias{compare_values}
\title{Compare two values and get talking points}
\usage{
compare_values(
  x,
  y,
  trend_phrases = headliner::trend_terms(),
  orig_values = "{x} vs. {y}",
  plural_phrases = NULL,
  n_decimal = 1,
  round_all = TRUE,
  multiplier = 1,
  check_rounding = TRUE
)
}
\arguments{
\item{x}{a numeric value to compare to the reference value of 'y'}

\item{y}{a numeric value to act as a control for the 'x' value}

\item{trend_phrases}{list of values to use for when y is more than x, y is the
same as x, or y is less than x. You can pass it just
\code{\link{trend_terms}} (the default) and call the result with
\code{"...{trend}..."} or pass is a named list (see examples)}

\item{orig_values}{a string using \code{\link[glue]{glue}} syntax.
example: \verb{(\{x\} vs \{y\})}}

\item{plural_phrases}{named list of values to use when difference (delta) is
singular (delta = 1) or plural (delta != 1)}

\item{n_decimal}{numeric value to limit the number of decimal places in
the returned values.}

\item{round_all}{logical value to indicate if all values should be rounded.
When FALSE, the values will return with no modification. When TRUE (default)
all values will be round to the length specified by 'n_decimal'.}

\item{multiplier}{number indicating the scaling factor. When multiplier = 1
(default), 0.25 will return 0.25. When multiplier = 100, 0.25 will return 25.}

\item{check_rounding}{when TRUE (default) inputs will be checked to confirm if
a difference of zero may be due to rounding. Ex: 0.16 and 0.24 with
'n_decimal = 1' will both return 0.2. Because this will show no difference,
a message will be displayed}
}
\value{
\code{compare_values()} returns a list object that can be used with
\code{\link[glue]{glue}} syntax
}
\description{
A function to create "talking points" that
describes the difference between two values.
}
\details{
Given \code{compare_values(x = 8, y = 10)} the following items will be returned
in the list:\tabular{lll}{
   item \tab value \tab description \cr
   \code{x} \tab 2 \tab original \code{x} value to compare against \code{y} \cr
   \code{y} \tab 10 \tab original \code{y} value \cr
   \code{delta} \tab 8 \tab absolute difference between \code{x} & \code{y} \cr
   \code{delta_p} \tab 80 \tab \% difference between \code{x} & \code{y} \cr
   \code{article_delta} \tab "an 8" \tab \code{delta} with the article included \cr
   \code{article_delta_p} \tab "an 80" \tab \code{delta_p} with the article included \cr
   \code{raw_delta} \tab -8 \tab true difference between \code{x} & \code{y} \cr
   \code{raw_delta_p} \tab -80 \tab true \% difference between \code{x} & \code{y} \cr
   \code{article_raw_delta} \tab "a -8" \tab \code{raw_delta} with the article \cr
   \code{article_raw_delta_p} \tab "a -80" \tab \code{raw_delta_p} with the article \cr
   \code{sign} \tab -1 \tab the direction, 1 (increase), -1 (decrease), or 0 (no change) \cr
   \code{orig_values} \tab "2 vs. 10" \tab shorthand for \verb{\{x\} vs \{y\}} \cr
   \code{trend} \tab "decrease" \tab influenced by the values in \code{trend_phrases} argument \cr
}
}
\examples{
# the values can be manually entered

compare_values(10, 8) |> head(2)
# percent difference (10-8)/8
compare_values(10, 8)$delta_p

# trend_phrases returns an object called trend if nothing is passed
compare_values(10, 8)$trend

# or if one argument is passed using trend_terms()
compare_values(10, 8, trend_phrases = trend_terms(more = "higher"))$trend

# if a named list is used, the objects are called by their names
compare_values(
  10, 8,
  trend_phrases = list(
    more = trend_terms(),
    higher = trend_terms("higher", "lower")
  )
)$higher

# a phrase about the comparison can be edited by providing glue syntax
# 'c' = the 'compare' value, 'r' = 'reference'
compare_values(10, 8, orig_values = "{x} to {y} people")$orig_values

# you can also adjust the rounding, although the default is 1
compare_values(0.1234, 0.4321)$orig_values
compare_values(0.1234, 0.4321, n_decimal = 3)$orig_values
# or add a multiplier
compare_values(0.1234, 0.4321, multiplier = 100)$orig_values
}
\seealso{
\code{\link[=headline]{headline()}}, \code{\link[=trend_terms]{trend_terms()}}, \code{\link[=plural_phrasing]{plural_phrasing()}} and \code{\link[=view_list]{view_list()}}
}
