% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common.R
\name{groupedLOCF}
\alias{groupedLOCF}
\title{Last observation carried forward}
\usage{
groupedLOCF(df, id)
}
\arguments{
\item{df}{data frame sorted by an ID column and a time or sequence number
column.}

\item{id}{A column name (in ticks) in df to group rows by.}
}
\value{
A data frame where the last non-NA values are carried forward
(overwriting NAs) until the group ID changes.
}
\description{
Carries the last observed value forward for all columns in a data.table
grouped by an id.
}
\examples{
df <- data.frame(personID=c(1,1,2,2,3,3,3),
                wt=c(.5,NA,NA,NA,.3,.7,NA),
                ht=c(NA,1,3,NA,4,NA,NA),
                date=c('01/01/2015','01/15/2015','01/01/2015','01/15/2015',
                       '01/01/2015','01/15/2015','01/30/2015'))

head(df,n=7)

dfResult <- groupedLOCF(df, 'personID')

head(dfResult, n = 7)
}
\references{
\url{http://healthcare.ai}
}
\seealso{
\code{\link{healthcareai}}
}
