% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common.R
\name{orderByDate}
\alias{orderByDate}
\title{Order the rows in a data frame by date}
\usage{
orderByDate(df, dateCol, descending = FALSE)
}
\arguments{
\item{df}{A data frame}

\item{dateCol}{Name of column in data frame that contains dates}

\item{descending}{Boolean for whether the output should be in descending order}
}
\value{
A data frame ordered by date column
}
\description{
Returns a data frame that's ordered by its date column
}
\examples{
df <- data.frame(date=c('2009-01-01','2010-01-01','2009-03-08','2009-01-19'),
                a=c(1,2,3,4))
dfResult <- orderByDate(df,'date', descending=FALSE)
head(dfResult)
}
\references{
\url{http://healthcare.ai}
}
\seealso{
\code{\link{healthcareai}}
}
