% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common-find-variation.R
\name{createVarianceTallTable}
\alias{createVarianceTallTable}
\title{Transform a dataframe to be three columns and tall instead of wide}
\usage{
createVarianceTallTable(df, categoricalCols, measure)
}
\arguments{
\item{df}{A dataframe}

\item{categoricalCols}{Vector of strings, representing categorical column(s)}

\item{measure}{String, representing measure column}
}
\value{
A dataframe of eight columns. MeasureVolumeRaw denotes number of rows 
in the particular subgroup; MeasureVolumePercent denotes percent of rows in 
that subgroup as a percentage of the above subgroup (i.e., F within Gender);
MeasureImpact is the subgroup COV * VolRaw (i.e., num of rows).
}
\description{
When dealing with a table that could be unexpectedly wide,
it helps to instead fix its width and let it get tall (which makes it easy
to insert into a pre-existing table). This assists the findVariation 
function.
}
\examples{
df <- data.frame(LactateOrderProvSpecDSC = c("Pulmonary Disease",
                                             "Family Medicine"),
                 LactateOrderProvNM = c("Hector Salamanca",
                                        "Gus Fring"),
                 COV = c(0.43,0.35),
                 VolumeRaw = c(2,3),
                 VolumePercent = c(0.32,0.78),
                 Impact = c(0.46,1.05),
                 AboveMeanCOVFLG = c('Y','N'),
                 AboveMeanVolumeFLG = c('N','Y'))

head(df)

categoricalCols <- c("LactateOrderProvSpecDSC","LactateOrderProvNM")

dfRes <- createVarianceTallTable(df = df, 
                                 categoricalCols = categoricalCols, 
                                 measure = "LOS")
head(dfRes)
}
\references{
\url{http://healthcareai-r.readthedocs.io}
}
\seealso{
\code{\link{healthcareai}} 
\code{\link{findVariation}}
}
