% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step_locfimpute.R
\name{step_locfimpute}
\alias{step_locfimpute}
\alias{tidy.step_locfimpute}
\title{Last Observation Carried Forward Imputation}
\usage{
step_locfimpute(
  recipe,
  ...,
  role = NA,
  trained = FALSE,
  skip = FALSE,
  id = rand_id("bagimpute")
)

\method{tidy}{step_locfimpute}(x, ...)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the sequence of
operations for this recipe.}

\item{...}{One or more selector functions to choose which variables will be
imputed. See [selections()] for more details. For the `tidy` method, these
are not currently used.}

\item{role}{Not used by this step since no new variables are created.}

\item{trained}{A logical to indicate if the number of NA values have been
counted in preprocessing.}

\item{skip}{A logical. Should the step be skipped when the recipe is baked?}

\item{id}{a unique step id that will be used to unprep}

\item{x}{A `step_locfimpute` object.}
}
\value{
For \code{step_locfimpute}, an updated version of recipe with the new
  step added to the sequence of existing steps (if any). For the \code{tidy}
  method, a tibble with columns \code{terms} (the selectors or variables
  selected) and \code{trained} (a logical that states whether the recipe has
  been prepped).
}
\description{
\code{step_locfimpute} creates a *specification* of a recipe
  step that will substitute missing values with the most recent variable
  value. If the first variable value is missing, it is imputed with the first
  present value.
}
\examples{
library(recipes)

prepped <-
  recipe(formula = "~.", pima_diabetes) \%>\%
  step_locfimpute(weight_class, insulin, skinfold, diastolic_bp) \%>\%
  prep()

bake(prepped, new_data = pima_diabetes)
}
