% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_test_dat.R
\name{make_test_dat}
\alias{make_test_dat}
\title{Make test data}
\usage{
make_test_dat(
  vals_kept = c("304", "305", 3040:3049, 3050:3059),
  noise_val = "999",
  IDs = 1:50,
  date_range = seq(as.Date("2015-01-01"), as.Date("2020-12-31"), by = 1),
  nrows = 100,
  n_any = 50,
  n_all = 10,
  seed = NULL,
  answer_id = NULL,
  type = c("data.frame", "database")
)
}
\arguments{
\item{vals_kept}{A vector of values that suppose to be identified.}

\item{noise_val}{A vector of values that are not meant to be identified.}

\item{IDs}{A vector of client IDs.}

\item{date_range}{A vector of all possible dates in the data.}

\item{nrows}{Number of rows of the output.}

\item{n_any}{Number of rows to be identified if the criteria is that if any target column contains certain values.}

\item{n_all}{Number of rows to be identified if the criteria is that if all target columns contain certain values.}

\item{seed}{Seed for random number generation.}

\item{answer_id}{Column name for the indicator of how the row should be identified: any, all, and noise.}

\item{type}{Output type, "data.frame" or "database".}
}
\value{
A data.frame or remote table from 'dbplyr'.
}
\description{
Make a toy data set for testing and demo. This is for internal use purpose and not intended to be called by users.
}
\examples{
make_test_dat() \%>\% head()
}
