% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vec-ts-growth-rate.R
\name{ts_growth_rate_vec}
\alias{ts_growth_rate_vec}
\title{Vector Function Time Series Growth Rate}
\usage{
ts_growth_rate_vec(.x, .scale = 100, .power = 1, .log_diff = FALSE, .lags = 1)
}
\arguments{
\item{.x}{A numeric vector}

\item{.scale}{A numeric value that is used to scale the output}

\item{.power}{A numeric value that is used to raise the output to a power}

\item{.log_diff}{A logical value that determines whether the output is a log difference}

\item{.lags}{An integer that determines the number of lags to use}
}
\value{
A list object of workflows.
}
\description{
This function computes the growth rate of a numeric vector,
typically representing a time series, with optional transformations like
scaling, power, and lag differences.
}
\details{
The function calculates growth rates for a time series, allowing for scaling,
exponentiation, and lag differences. It can be useful for financial data analysis,
among other applications.

The growth rate is computed as follows:
\itemize{
\item If lags is positive and log_diff is FALSE:
growth_rate = (((x / lag(x, lags))^power) - 1) * scale
\item If lags is positive and log_diff is TRUE:
growth_rate = log(x / lag(x, lags)) * scale
\item If lags is negative and log_diff is FALSE:
growth_rate = (((x / lead(x, -lags))^power) - 1) * scale
\item If lags is negative and log_diff is TRUE:
growth_rate = log(x / lead(x, -lags)) * scale
}
}
\examples{
# Calculate the growth rate of a time series without any transformations.
ts_growth_rate_vec(c(100, 110, 120, 130))

# Calculate the growth rate with scaling and a power transformation.
ts_growth_rate_vec(c(100, 110, 120, 130), .scale = 10, .power = 2)

# Calculate the log differences of a time series with lags.
ts_growth_rate_vec(c(100, 110, 120, 130), .log_diff = TRUE, .lags = -1)

# Plot
plot.ts(AirPassengers)
plot.ts(ts_growth_rate_vec(AirPassengers))

}
\seealso{
Other Vector Function: 
\code{\link{ts_acceleration_vec}()},
\code{\link{ts_velocity_vec}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Vector Function}
