% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/augment-ts-velocity.R
\name{ts_velocity_augment}
\alias{ts_velocity_augment}
\title{Augment Function Velocity}
\usage{
ts_velocity_augment(.data, .value, .names = "auto")
}
\arguments{
\item{.data}{The data being passed that will be augmented by the function.}

\item{.value}{This is passed \code{\link[rlang:enquo]{rlang::enquo()}} to capture the vectors you want
to augment.}

\item{.names}{The default is "auto"}
}
\value{
A augmented
}
\description{
Takes a numeric vector and will return the velocity of that vector.
}
\details{
Takes a numeric vector and will return the velocity of that vector. The
velocity of a time series is computed by taking the first difference, so
\deqn{x_t - x_t1}

This function is intended to be used on its own in order to add columns to a
tibble.
}
\examples{
suppressPackageStartupMessages(library(dplyr))

len_out    = 10
by_unit    = "month"
start_date = as.Date("2021-01-01")

data_tbl <- tibble(
  date_col = seq.Date(from = start_date, length.out = len_out, by = by_unit),
  a    = rnorm(len_out),
  b    = runif(len_out)
)

ts_velocity_augment(data_tbl, b)

}
\seealso{
Other Augment Function: 
\code{\link{ts_acceleration_augment}()},
\code{\link{ts_growth_rate_augment}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Augment Function}
