% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strategy_print.R
\name{plot.run_model}
\alias{plot.run_model}
\title{Plot Results of a Markov Model}
\usage{
\method{plot}{run_model}(x, type = c("counts", "ce", "values"),
  panels = c("by_strategy", "by_state", "by_value"), values = NULL,
  strategy = NULL, states = NULL, free_y = FALSE, bw = FALSE, ...)
}
\arguments{
\item{x}{Result from \code{\link{run_model}}.}

\item{type}{Type of plot, see details.}

\item{panels}{Should plots be faceted by model, by
value or by state?}

\item{values}{Names of values to be plotted. These can be
any of the costs or effects defined in states.}

\item{strategy}{Name or position of model(s) of interest.}

\item{states}{Names of states to be included in
the plot.}

\item{free_y}{Should y limits be free between panels?}

\item{bw}{Black & white plot for publications?}

\item{...}{Additional arguments passed to \code{plot}.
  
\code{type = "counts"} represents state
memberships (corrected) by cycle, \code{type = "ce"}
plots models on the cost-efficiency plane with the
efficiency frontier, and \code{type = "values"} state
values per cycle.}
}
\value{
A \code{ggplot2} object.
}
\description{
Various plots for Markov models.
}
\examples{

## These examples require \\code{res_mod} from the hip replacement model discussed in
## `vignette("non-homogeneous", package = "heemod")`.

\dontrun{
  plot(res_mod)

  plot(res_mod, model = "all")
  plot(res_mod, model = "all", panels = "by_state")

  plot(res_mod, model = "all", include_states = c("RevisionTHR", "SuccessR"))
  plot(res_mod, model = "all", panels = "by_state", include_states = c("RevisionTHR", "SuccessR"))
 
  plot(res_mod, model = 2, panel = "by_state", include_states = c("RevisionTHR", "SuccessR"))
  
}
}

