% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\name{progress}
\alias{progress}
\title{Get progress information from a batch result}
\usage{
progress(x, ...)
}
\arguments{
\item{x}{A batch object}

\item{...}{Additional arguments passed to methods}
}
\value{
A list containing progress details
}
\description{
Get progress information from a batch result
}
\examples{
\dontshow{if (ellmer::has_credentials("openai")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Create a chat processor
chat <- chat_sequential(chat_openai())

# Process a batch of prompts
batch <- chat$batch(list(
  "What is R?",
  "Explain base R versus tidyverse",
  "Explain vectors, lists, and data frames"
))

# Check the progress
batch$progress()
\dontshow{\}) # examplesIf}
}
