% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batch-methods.R
\name{batch.sequential_chat}
\alias{batch.sequential_chat}
\title{Process a batch of prompts with a sequential chat}
\usage{
batch.sequential_chat(
  chat_env,
  prompts,
  type_spec = NULL,
  judgements = 0,
  state_path = tempfile("chat_", fileext = ".rds"),
  progress = TRUE,
  max_retries = 3L,
  initial_delay = 20,
  max_delay = 80,
  backoff_factor = 2,
  beep = TRUE,
  echo = FALSE,
  ...
)
}
\arguments{
\item{chat_env}{The chat environment from chat_sequential}

\item{prompts}{List of prompts to process}

\item{type_spec}{Type specification for structured data extraction}

\item{judgements}{Number of judgements (1 = initial extract + 1 judgement, 2 = initial extract + 2 judgements, etc.)}

\item{state_path}{Path to save state file}

\item{progress}{Whether to show progress bars}

\item{max_retries}{Maximum number of retry attempts for failed requests}

\item{initial_delay}{Initial delay before first retry in seconds}

\item{max_delay}{Maximum delay between retries in seconds}

\item{backoff_factor}{Factor to multiply delay by after each retry}

\item{beep}{Whether to play a sound on completion}

\item{echo}{Whether to display chat outputs (when \code{progress} is \code{FALSE})}

\item{...}{Additional arguments passed to the chat method}
}
\value{
A batch object with the processed results
}
\description{
Process a batch of prompts with a sequential chat
}
