% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hellmer.R
\name{chat_future}
\alias{chat_future}
\title{Process a batch of prompts in parallel}
\usage{
chat_future(chat_model = NULL, ...)
}
\arguments{
\item{chat_model}{ellmer chat model object or function (e.g., \code{chat_openai()})}

\item{...}{Additional arguments passed to the underlying chat model (e.g., \code{system_prompt})}
}
\value{
A batch object (S7 class) containing:
\itemize{
\item \strong{prompts}: Original input prompts
\item \strong{responses}: Raw response data for completed prompts
\item \strong{completed}: Number of successfully processed prompts
\item \strong{state_path}: Path where batch state is saved
\item \strong{type_spec}: Type specification used for structured data
\item \strong{texts}: Function to extract text responses or structured data
\item \strong{chats}: Function to extract chat objects
\item \strong{progress}: Function to get processing status
\item \strong{batch}: Function to process a batch of prompts
}
}
\description{
Processes a batch of chat prompts using parallel workers.
Splits prompts into chunks for processing while maintaining state.
For sequential processing, use \code{chat_sequential()}.
}
\section{Batch Method}{

This function provides access to the \code{batch()} method for parallel processing of prompts.
See \code{?batch.future_chat} for full details of the method and its parameters.
}

\examples{
\dontshow{if (ellmer::has_credentials("openai")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Create a parallel chat processor with an object
chat <- chat_future(chat_openai(system_prompt = "Reply concisely"))

# Or a function
chat <- chat_future(chat_openai, system_prompt = "Reply concisely, one sentence")

# Process a batch of prompts in parallel
batch <- chat$batch(
  list(
    "What is R?",
    "Explain base R versus tidyverse",
    "Explain vectors, lists, and data frames"
  ),
  chunk_size = 3
)

# Process batch with echo enabled (when progress is disabled)
batch <- chat$batch(
  list(
    "What is R?",
    "Explain base R versus tidyverse"
  ),
  progress = FALSE,
  echo = TRUE
)

# Check the progress if interrupted
batch$progress()

# Return the responses
batch$texts()

# Return the chat objects
batch$chats()
\dontshow{\}) # examplesIf}
}
