% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/params.R
\name{params_lm_list}
\alias{params_lm_list}
\title{Parameters of a list of linear models}
\usage{
params_lm_list(...)
}
\arguments{
\item{...}{Objects of class \link{params_lm}, which can be named.}
}
\value{
An object of class \code{params_lm_list}, which is a list containing \link{params_lm}
objects.
}
\description{
Create a list containing the parameters of a list of fitted linear regression models.
}
\examples{
n <- 2
coefs1 <- MASS::mvrnorm(n, mu = c(.5,.6),
                        Sigma = matrix(c(.05, .01, .01, .05), nrow = 2))
sigma1 <- rgamma(n, shape = .5, rate = 4)
params1 <- params_lm(coefs = coefs1, sigma = sigma1)
coefs2 <- MASS::mvrnorm(n, mu = c(.2,.9),
                        Sigma = matrix(c(.08, .02, .02, .08), nrow = 2))
sigma2 <- rgamma(n, shape = .9, rate = 4)
params2 <- params_lm(coefs = coefs2, sigma = sigma2)
params_list <- params_lm_list(params1, params2)
print(params_list)
}
\keyword{internal}
