% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_def.R
\name{tpmatrix}
\alias{tpmatrix}
\title{Transition probability matrix}
\usage{
tpmatrix(...)
}
\arguments{
\item{...}{Named values of expressions defining elements of the matrix. See
"Details" and the example below.}
}
\value{
Returns a \code{tpmatrix} object that inherits from \code{data.table}
where each column is an element of the transition probability matrix with
elements ordered rowwise.
}
\description{
\code{tpmatrix()} both defines and evaluates a transition probability matrix in which
elements are expressions. It can be used within \code{\link[=define_tparams]{define_tparams()}} to
create a transition probability matrix or directly to create a \code{\link[=tparams_transprobs]{tparams_transprobs()}}
object. These are, in turn, ultimately used to create a \link{CohortDtstmTrans} object
for simulating health state transitions.
}
\details{
The matrix is filled rowwise, meaning that each row should sum to 1.
The complementary probability (equal to 1 minus the sum of the probabilities
of all other rows) can be conveniently referred to as \code{C}.
}
\examples{
p <- c(.7, .6)
tpmatrix(
  C, p,
  0, 1
)
}
\seealso{
\code{\link[=define_model]{define_model()}}, \code{\link[=define_tparams]{define_tparams()}},
\code{\link[=tpmatrix_id]{tpmatrix_id()}}, \code{\link[=tparams_transprobs]{tparams_transprobs()}}, \code{\link[=CohortDtstmTrans]{CohortDtstmTrans()}}
}
