% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IMSE.R
\name{horizon}
\alias{horizon}
\title{Adapt horizon}
\usage{
horizon(
  model,
  current_horizon = NULL,
  previous_ratio = NULL,
  target = NULL,
  Wijs = NULL
)
}
\arguments{
\item{model}{\code{hetGP} or \code{homGP} model}

\item{current_horizon}{horizon used for the previous iteration, see details}

\item{previous_ratio}{ratio before adding the previous new design}

\item{target}{scalar in ]0,1] for desired n/N}

\item{Wijs}{optional previously computed matrix of Wijs, see \code{\link[hetGP]{Wij}}}
}
\value{
randomly selected horizon for next iteration (adpative) if no \code{target} is provided, 
otherwise returns the update horizon value.
}
\description{
Adapt the look-ahead horizon depending on the replicate allocation or a target ratio
}
\details{
If \code{target} is provided, along with \code{previous_ratio} and \code{current_horizon}:
\itemize{
\item the horizon is increased by one if more replicates are needed but a new ppint has been added at the previous iteration,
\item the horizon is decreased by one if new points are needed but a replicate has been added at the previous iteration,
\item otherwise it is unchanged.
}

If no \code{target} is provided, \code{\link[hetGP]{allocate_mult}} is used to obtain the best allocation of the existing replicates,
then the new horizon is sampled from the difference between the actual allocation and the best one, bounded below by 0.
See (Binois et al. 2017).
}
\references{
M. Binois, J. Huang, R. B. Gramacy, M. Ludkovski (2019), 
Replication or exploration? Sequential design for stochastic simulation experiments,
Technometrics, 61(1), 7-23.\cr 
Preprint available on arXiv:1710.03206.
}
