#' Heart Disease Dataset.
#'
#' This database contains 76 attributes, but all published experiments refer to using a subset of 14 of
#' them. In particular, the Cleveland database is the only one that has been used by ML researchers to
#' this date. The "goal" field refers to the presence of heart disease in the patient. It is integer valued
#' from 0 (no presence) to 4. Experiments with the Cleveland database have concentrated on simply attempting
#' to distinguish presence (values 1,2,3,4) from absence (value 0).
#'
#' @docType data
#'
#' @usage data(heart)
#'
#' @format A data frame with 303 rows and 13 variables:
#' \describe{
#'   \item{age}{age in years}
#'   \item{sex}{sex (1 = male; 0 = female)}
#'   \item{cp}{cp: chest pain type}
#'   \item{trestbps}{trestbps: resting blood pressure (in mm Hg on admission to the hospital)}
#'   \item{chol}{chol: serum cholestoral in mg/dl}
#'   \item{fbs}{fbs: (fasting blood sugar > 120 mg/dl) (1 = true; 0 = false)}
#'   \item{restecg}{restecg: resting electrocardiographic results}
#'   \item{thalach}{thalach: maximum heart rate achieved}
#'   \item{exang}{exang: exercise induced angina (1 = yes; 0 = no)}
#'   \item{oldpeak}{oldpeak = ST depression induced by exercise relative to rest}
#'   \item{slope}{slope: the slope of the peak exercise ST segment}
#'   \item{ca}{ca: number of major vessels (0-3) colored by flourosopy}
#'   \item{thal}{thal: 3 = normal; 6 = fixed defect; 7 = reversable defect}
#'   \item{num}{num: diagnosis of heart disease (angiographic disease status)}
#' }
#' @source \url{https://archive.ics.uci.edu/ml/datasets/Heart+Disease}
"heart"
