% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_min_node_impurity.R
\name{invoke_model}
\alias{invoke_model}
\title{invoke_model.}
\usage{
invoke_model(
  X,
  y,
  try_this_min_imp,
  iter,
  response,
  mni_n_folds,
  mni_n_trees,
  useIdentity,
  seed
)
}
\arguments{
\item{X}{The feature variables we will use to train the HHDecisionTree model on.}

\item{y}{The target variable.}

\item{try_this_min_imp}{The minimum node impurity we will try on this invocation of
the HHDecisionTree model.}

\item{iter}{The number of times function invoke_model has been invoked, used to
increment a number that is passed to the function set.seed().}

\item{response}{The response parameter is used to specify what type of model to build, either 'classify'
for a classification tree model or 'regressor' for a regression tree model. The default is 'classify'.}

\item{mni_n_folds}{The number of folds to pass to mni.control to be used to instantiate
a HHDecisionTree model when searching for an optimum value of min_node_impurity.}

\item{mni_n_trees}{The number of trees to pass to mni.control to be used to instantiate
a HHDecisionTree model when searching for an optimum value of min_node_impurity.}

\item{useIdentity}{The useIdentity parameter when set TRUE will result in hhcartr using the
original training data to find the optimal splits rather than using the reflected data. The
default value is FALSE.}

\item{seed}{The seed parameter is used to provide a seed value for the R random number
generator to ensure repeatable experiments.}
}
\value{
Returns statistics on the current run of the HHDecisionTree model.
}
\description{
This function instantiates a HHDecisionTree model, it is used to induce classification
or regression trees depending upon the value of the response parameter. It supports
the parameters listed below. It is used to find the optimum value for min_node_impurity.
}
