% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hhcartr_export_predict.R
\name{predict.hhcartr}
\alias{predict.hhcartr}
\title{predict - Create generic S3method to make predictions via predict.hhcartr.
Needs export entry in the NAMESPACE file.}
\usage{
\method{predict}{hhcartr}(object, ..., test_data)
}
\arguments{
\item{object}{Unused parameter.}

\item{...}{Unused parameter.}

\item{test_data}{The test dataset the user wants to make predictions on.}
}
\value{
exposes the accuracy() and predictions() methods.
}
\description{
This function creates a generic S3method predict which is used to call predict.hhcartr when
an object of type hhcartr passed to the predict function, i.e. an object that is returned
from the fit() function. The object created from the predict function supports the accuracy and
predictions methods. The accuracy method returns the accuracy achieved on the test_data and the
method predictions returns the actual predictions made on the test_data.
}
\examples{
# source: /man/examples/predict.R

# Basic usage of predict().

# Note: we need to have a model to modify first.

# load our data.
X <- iris[,1:4]
y <- iris[,5]

# instantiate our model.
clf = HHDecisionTree(n_folds=1,
                     n_trees=1,
                     pruning=FALSE,
                     min_node_impurity=0.0)

# describe what dataset our model is using.
setDataDescription("IRIS Dataset")

# train our model.
model_output <- clf$fit(X, y)

# make predictions on an unseen test set.
# As the IRIS dataset provides no separate test set,
# for the sake of this example we will predict on the original data
# and pretend it is previously unseen data.
preds <- predict(model_output, test_data = iris)

# The predict object 'preds' exposes the following methods
# that we can use to extract the results of interest
# (depending upon model options used):

# preds$accuracy and preds$predictions.
}
