% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate-hhsmm.R
\name{simulate.hhsmmspec}
\alias{simulate.hhsmmspec}
\title{Simulation of data from hhsmm model}
\usage{
\method{simulate}{hhsmmspec}(object, nsim, seed = NULL, remission = rmixmvnorm, ...)
}
\arguments{
\item{object}{a \code{\link{hhsmmspec}} model}

\item{nsim}{a vector of sequence lengths (might be of length 1)}

\item{seed}{a random seed to be set}

\item{remission}{a random emission generation function (default = \code{\link{rmixmvnorm}})}

\item{...}{additional parameters of the \code{remission} function}
}
\value{
a list of class \code{"hsmm.data"} containing the following items:
\itemize{
\item \code{s}{ the vector of states}
\item \code{x}{ observation matrix}
\item\code{N}{ vector of sequence lengths}
}
}
\description{
Simulates a data set of class \code{"hhsmmdata"} using a \code{\link{hhsmmspec}} model
}
\examples{
J <- 3
initial <- c(1,0,0)
semi <- c(FALSE,TRUE,FALSE)
P <- matrix(c(0.8, 0.1, 0.1, 0.5, 0, 0.5, 0.1, 0.2, 0.7), nrow = J, byrow=TRUE)
par <- list(mu = list(list(7,8),list(10,9,11),list(12,14)),
sigma = list(list(3.8,4.9),list(4.3,4.2,5.4),list(4.5,6.1)),
mix.p = list(c(0.3,0.7),c(0.2,0.3,0.5),c(0.5,0.5)))
sojourn <- list(shape = c(0,3,0), scale = c(0,8,0), type = "gamma")
model <- hhsmmspec(init = initial, transition = P, parms.emis = par,
dens.emis = dmixmvnorm, sojourn = sojourn, semi = semi)
train <- simulate(model, nsim = c(8,5,5,10), seed = 1234, remission = rmixmvnorm)

}
\author{
Morteza Amini, \email{morteza.amini@ut.ac.ir}, Afarin Bayat, \email{aftbayat@gmail.com}
}
