% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api-hc-hc_add_series-deprecated.R
\name{hc_add_series_ohlc}
\alias{hc_add_series_ohlc}
\title{Shortcut  for create candlestick charts}
\usage{
hc_add_series_ohlc(hc, x, type = "candlestick", ...)
}
\arguments{
\item{hc}{A \code{highchart} \code{htmlwidget} object.}

\item{x}{A \code{ohlc} object from the \pkg{quantmod} package.}

\item{type}{The type of chart. Can be \code{candlestick} or \code{ohlc}.}

\item{...}{Additional shared arguments for the data series
(\url{http://api.highcharts.com/highcharts#series}).}
}
\description{
This function helps to create candlestick from \code{xts} objects
obtaining by \code{getSymbols} function from the  \pkg{quantmod}.
}
\examples{
  

\dontrun{

library("xts")

data(sample_matrix)

matrix_xts <- as.xts(sample_matrix, dateFormat = "Date")

head(matrix_xts)

class(matrix_xts)

highchart() \%>\% 
  hc_add_series_ohlc(matrix_xts)
   
library("quantmod")

x <- getSymbols("AAPL", auto.assign = FALSE)
y <- getSymbols("SPY", auto.assign = FALSE)

highchart() \%>\% 
  hc_add_series_ohlc(x) \%>\% 
  hc_add_series_ohlc(y)
  
}
  
}
