% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_handling.R
\name{aggregatePrice}
\alias{aggregatePrice}
\title{Aggregate a time series but keep first and last observation}
\usage{
aggregatePrice(
  pData,
  on = "minutes",
  k = 1,
  marketOpen = "09:30:00",
  marketClose = "16:00:00",
  fill = FALSE,
  tz = NULL
)
}
\arguments{
\item{pData}{data.table or xts object to be aggregated containing the intraday price series, possibly across multiple days.}

\item{on}{character, indicating the time scale in which "k" is expressed. Possible values are: "milliseconds", "secs", "seconds", "mins", "minutes","hours", "ticks".}

\item{k}{positive integer, indicating the number of periods to aggregate over; e.g. to aggregate a
xts object to the 5 minute frequency set k = 5 and on = "minutes".}

\item{marketOpen}{the market opening time, by default: marketOpen = "09:30:00".}

\item{marketClose}{the market closing time, by default: marketClose = "16:00:00".}

\item{fill}{indicates whether rows without trades should be added with the most recent value, FALSE by default.}

\item{tz}{time zone used, by default: tz = timezone of DT column/index of xts.}
}
\value{
A data.table or xts object containing the aggregated time series.
}
\description{
Function returns new time series as xts object where first observation is always the opening price
and subsequent observations are the closing prices over the interval with as endpoint the timestamp
of the result.
}
\details{
The timestamps of the new time series are the closing times and/or days of the intervals.

In case of previous tick aggregation or on = "seconds"/"minutes"/"hours",
the element of the returned series with e.g. timestamp 09:35:00 contains
the last observation up to that point, including the value at 09:35:00 itself.

In case on = "ticks", the sampling is done such the sampling starts on the first tick, and the last tick is always included
For example, if 14 observations are made on one day, and these are 1, 2, 3, ... 14.
Then, with on = "ticks" and k = 3, the output will be 1, 4, 7, 10, 13, 14.
}
\examples{
# aggregate price data to the 30 second frequency
aggregatePrice(sampleTDataMicroseconds, on = "secs", k = 30)
# aggregate price data to the 30 second frequency including zero return price changes
aggregatePrice(sampleTDataMicroseconds, on = "secs", k = 30)

# aggregate price data to half a second frequency including zero return price changes
aggregatePrice(sampleTDataMicroseconds, on = "milliseconds", k = 500, fill = TRUE)
}
\author{
Jonathan Cornelissen, Kris Boudt and Onno Kleen.
}
\keyword{data}
\keyword{internal}
\keyword{manipulation}
