% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/liquidity_measures.R
\name{getTradeDirection}
\alias{getTradeDirection}
\title{Get trade direction}
\usage{
getTradeDirection(tqData)
}
\arguments{
\item{tqData}{data.table or xts object, containing joined trades and quotes (e.g. using \code{\link{matchTradesQuotes}})}
}
\value{
A vector which has values 1 or (-1) if the inferred trade direction
is buy or sell respectively.
}
\description{
Function returns a vector with the inferred trade direction which is 
determined using the Lee and Ready algorithm (Lee and Ready, 1991).
}
\details{
NOTE: The value of the first (and second) observation of the output should be ignored if price == midpoint
for the first (second) observation.
}
\examples{
# generate matched trades and quote data set
tqData <- matchTradesQuotes(sampleTData, sampleQData)
directions <- getTradeDirection(tqData)
head(directions)

}
\references{
Lee, C. M. C. and M. J. Ready (1991). Inferring trade direction from intraday data. Journal of Finance 46, 733-746.
}
\author{
Jonathan Cornelissen, Kris Boudt and Onno Kleen. Special thanks to Dirk Eddelbuettel.
}
\keyword{liquidity}
