% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataHandling.R
\name{makeReturns}
\alias{makeReturns}
\title{Compute log returns}
\usage{
makeReturns(ts)
}
\arguments{
\item{ts}{a possibly multivariate matrix-like object containing prices in levels. If \code{ts} is an \code{xts} object, we return an \code{xts} object. Other types will result in a \code{matrix}}
}
\value{
Depending on input, either a \code{matrix} or an \code{xts} object containing the log returns.
}
\description{
Convenience function to calculate log-returns, also used extensively internally.
Accepts \code{xts} and \code{matrix}-like objects. If you use this with a \code{data.table} object, remember to not pass the \code{DT} column.
\deqn{
\mbox{log return}_t =  (\log(\mbox{PRICE}_{t})-\log(\mbox{PRICE}_{t-1})).
}
}
\details{
Note: the first (row of) observation(s) is set to zero.
}
\author{
Jonathan Cornelissen, Kris Boudt, and Emil Sjoerup
}
