% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\name{hi_solver_set_options}
\alias{hi_solver_set_options}
\title{Set Multiple HiGHS Solver Options}
\usage{
hi_solver_set_options(solver, control = list())
}
\arguments{
\item{solver}{A HiGHS solver object of class \code{"highs_solver"}.}

\item{control}{A named list of options to set. Names should be valid option names and values will be coerced to the appropriate types.}
}
\value{
Invisibly returns NULL.
}
\description{
Sets multiple options for a HiGHS solver instance at once.
}
\examples{
solver <- example_solver()
hi_solver_set_options(solver, list(output_flag = FALSE, solver = "simplex"))

control <- list(
  presolve = "on",
  solver = "simplex",
  parallel = "on",
  ranging = "off",
  time_limit = 100.0,
  
  primal_feasibility_tolerance = 1e-7,
  dual_feasibility_tolerance = 1e-7,
  random_seed = 1234,
  threads = 4,
  
  output_flag = TRUE,
  log_to_console = TRUE,
  
  run_crossover = "on",
  allow_unbounded_or_infeasible = FALSE,
  
  mip_detect_symmetry = TRUE,
  mip_max_nodes = 10000,
  mip_max_leaves = 5000,
  mip_feasibility_tolerance = 1e-6
)
hi_solver_set_options(solver, control)
}
