% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/return.level.R
\name{return.level}
\alias{return.level}
\title{The associated return level}
\usage{
return.level(period, loc, scale, shape)
}
\arguments{
\item{period}{An integer indicating the wished return period T.}

\item{loc}{A numerical value or vector for the GEV location parameter. Must be of length one or same length as \code{scale} and/or \code{shape}.}

\item{scale}{A numerical value or vector for the GEV scale parameter. Must be of length one or same length as \code{loc} and/or \code{shape}.}

\item{shape}{A numerical value or vector for the GEV shape parameter. Must be of length one or same length as \code{loc} and/or \code{scale}.}
}
\value{
A numerical value or a numerical vector, depending on the input arguments \code{loc}, \code{scale}, \code{shape}
}
\description{
Computation of the associated return level with given period and GEV parameters.
}
\details{
The \eqn{T}-year return level is a common value of risk in Extreme Value Theory. It represents the value that is expected to be exceeded once over \eqn{T} years by the annual maxima. Given the parameters \eqn{\mu}, \eqn{\sigma} and \eqn{\xi} of the GEV distribution associated to the yearly maxima, we can compute the associated \eqn{T}-return level \eqn{y_T} by:
\deqn{y_T := \mu + \frac{\sigma}{\xi} \left[ \log\left(\frac{T}{T-1}\right)^{-\xi} -1 \right] ~.}
}
\examples{
return.level(period = 100, loc = 1, scale = 1, shape = 1)
return.level(period = 200, loc = 1:10, scale = 1, shape = 0)


}
\author{
Quentin Sebille
}

