% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genpoints.R
\name{generate_new_runs}
\alias{generate_new_runs}
\title{Generate Proposal Points}
\usage{
generate_new_runs(
  ems,
  n_points,
  z,
  method = "default",
  cutoff = 3,
  nth = NULL,
  plausible_set,
  verbose = interactive(),
  cluster = FALSE,
  resample = 1,
  seek = 0,
  c_tol = 0.5,
  i_tol = 0.01,
  to_file = NULL,
  imp_func = function(ems, x, z, ...) nth_implausible(ems, x, z, ...),
  ...
)
}
\arguments{
\item{ems}{A list of \code{\link{Emulator}} objects, trained on previous design points.}

\item{n_points}{The desired number of points to propose for the next wave.}

\item{z}{The targets to match to.}

\item{method}{The method(s) to use.}

\item{cutoff}{The implausibility cutoff(s) to compare outputs to.}

\item{nth}{A parameter to be passed to the \code{n} argument of \code{\link{nth_implausible}}.}

\item{plausible_set}{An optional set of known non-implausible points (for eg line sampling).}

\item{verbose}{Should progress statements be printed to the console?}

\item{cluster}{Should emulator clustering be considered in the LHS generation?}

\item{resample}{Number of times to resample using line and/or importance sampling.}

\item{seek}{How many `good' points to search for}

\item{c_tol}{The tolerance with which to determine that best implausibility has been reached.}

\item{i_tol}{The tolerance on final desired implausibility}

\item{to_file}{The filename to write to sequentially during proposal. Default is NULL (no writing)}

\item{imp_func}{The implausibility measure to use to determine point acceptance.}

\item{...}{Any parameters to pass to individual sampling functions, eg \code{distro} for importance sampling.}
}
\value{
A data.frame containing the set of new points to run the model at.
}
\description{
Given a set of trained emulators, this finds the next set of points that will be
informative for a subsequent wave of emulation.
}
\details{
If the method is \code{'lhs'}, a Latin hypercube is generated and non-implausible
points from this design are retained. If enough points are accepted, the points
outputted are chosen using either a maximin or V-optimality criteria (chosen by
\code{measure.method}).

The methods \code{'line'} and \code{'importance'} both require a predetermined set
of non-implausible points \code{s_points}; if they are not provided then lhs sampling
is performed first.

The method \code{'line'} performs line sampling for boundary detection. Given a set of
non-implausible points, rays are drawn between pairs of points (selected so as to
maximise the distance between them), and more points are sampled along these lines.
Points are kept if they lie near a boundary of the non-implausible space.

The method \code{'importance'} performs importance sampling, using a mixture distribution
of multivariate normal or uniform spherical proposals around the current non-implausible
points (determined by \code{distro}). The optimal standard deviation or radius is found
using a burn-in phase, before the full set of points is generated.

The method \code{'slice'} performs slice sampling. Given one known non-implausible
point, it attempts to find a minimum enclosing hyperrectangle for the non-implausible
region around this point and samples uniformly from this, shrinking the hyperrectangle
as appropriate. This method is also called if LH sampling has only generated one point
(since any later methods require at least two points to be useful).

The method \code{'optical'} uses optical depth sampling: given a set of known
non-implausible points, the an approximation of the one-dimensional marginal distributions
in each parameter direction can be determined. From these derived marginals, points are
sampled.

For any sampling strategy, the parameters \code{ems} and \code{z} must be provided.
All of these methods depend on a means of assessing point suitability (henceforth
referred to as 'implausibility'). By default, this is uses nth-maximum implausibility
as provided by \code{\link{nth_implausible}}: a user-defined method can be substituted
for this by supplying the function call to \code{imp_func}. As a minimum, the function
should take four arguments: the emulators, the points, and the targets, and a \code{...}
argument to allow compatibility with the standard behaviour.

The option \code{seek} determines how many points should be chosen that have a higher
probability of matching targets, as opposed to not missing targets. Due to the danger of
such an approach in terms of obtaining a representative space-filling design over the
space, this value should not be too high: a rough guide is that it should be no larger
than 10\% of the desired number of points. The default is \code{seek = 0}. If \code{seek}
is in the range [0, 1], it is assumed to represent a proportion of the total number of
points that should be sought using this method; otherwise, it is assumed to be the number
of points that are desired.

The default behaviour is as follows. A set of initial points are generated from an LHD;
line sampling is performed to find the boundaries; and finally this collection of points
is augmented to the desired number of points by importance sampling using uniform
spherical proposals.

In regions where the non-implausible space (at the given cutoff) is very hard to find,
the function will start at a higher implausibility where it can find a space-filling
design; using this as a starting point any other methods are performed. From this new
proposal, a subset of lower-implausibility points are selected. This process iterates
until either the desired implausibility has been reached or the process has reached a
barrier to further reductions in implausibility. The argument \code{c_tol} is used to
determine if the improvement in implausibility is small enough to justify stopping the
process; by default this is 0.1. The process will also stop if it has produced points
`close to' the desired implausibility: the level of closeness is defined using the
\code{i_tol} argument.

These methods may not work, or may work slowly, if the target space is very small
compared to the current not-yet-ruled-out space, or it may miss small disconnected
regions of parameter space.
}
\examples{
\donttest{
 # A simple example that uses a number of the native and ... parameter options
 pts <- generate_new_runs(SIREmulators$ems, 100, SIREmulators$targets,
 measure.method = 'maximin', distro = 'sphere', resample = 0)
 pts_optical <- generate_new_runs(SIREmulators$ems, 100, SIREmulators$targets,
  method = c('optical'))
 pts_slice <- generate_new_runs(SIREmulators$ems, 100, SIREmulators$targets,
  method = c('slice'))
 pts_no_importance <- generate_new_runs(SIREmulators$ems, 100, SIREmulators$targets,
  method = c('line'))
}
}
